---
title: Operational guidance · Cloudflare Network Interconnect docs
description: Also refer to Monitoring and alerts.
lastUpdated: 2025-10-31T14:09:31.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/network-interconnect/operational-guidance/
  md: https://developers.cloudflare.com/network-interconnect/operational-guidance/index.md
---

## Understanding Maintenance and Availability

Also refer to [Monitoring and alerts](https://developers.cloudflare.com/network-interconnect/monitoring-and-alerts).

Cloudflare performs regular network maintenance that may impact CNI connectivity.

* **Maintenance impact**: Maintenance windows average six hours. Customers who are not redundantly connected to diverse devices, for instance in single-homed PoPs, will experience a complete service disruption on CNI in that location.
* **Designing for availability**: For critical applications, deploy CNI in locations that support diversity on the device level (multi-homed PoPs). Cloudflare does not guarantee coordinated maintenance between PoP locations.

## Troubleshooting

When facing connectivity problems, your first action should be to check for broader service disruptions. Visit `https://www.cloudflarestatus.com/` to see if any scheduled maintenance or active incidents are impacting services. This helps determine if the issue originates outside your network. Refer to [Monitoring and alerts](https://developers.cloudflare.com/network-interconnect/monitoring-and-alerts/).

If no system-wide problems are reported, gather the following information before submitting a support case. Providing comprehensive details facilitates a faster resolution:

* **Timeline**: When the issue began and ended (if applicable), including the timezone.
* **Identification**: The CNI IP address or point-to-point prefix for the impacted CNI. If your CNI is part of a Magic setup, please also provide the name of the Magic Transit/WAN interconnect as listed in your dashboard.
* **Physical Layer**: Light levels of the CNI link (if applicable).
* **Service Impact**: Confirmation whether Magic Transit / WAN traffic was affected.
* **Problem Description**: A clear summary of the issue (for example, CNI down, BGP session down, prefixes withdrawn).
