---
title: Issue challenge for admin user in JWT claim based on attack score ·
  Cloudflare Web Application Firewall (WAF) docs
description: This example configures additional protection for requests with a
  JSON Web Token (JWT) with a user claim of admin, based on the request's attack
  score.
lastUpdated: 2025-06-18T23:38:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/check-jwt-claim-to-protect-admin-user/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/check-jwt-claim-to-protect-admin-user/index.md
---

Note

To use claims inside a JSON Web Token (JWT), you must first set up a [token validation configuration](https://developers.cloudflare.com/api-shield/security/jwt-validation/api/) in API Shield.

This example configures additional protection for requests with a JSON Web Token (JWT) with a user claim of `admin`, based on the request's [attack score](https://developers.cloudflare.com/waf/detections/attack-score/).

Create a custom rule that issues a Managed Challenge if the user claim in a JWT is `admin` and the attack score is below 40.

* **Expression**: `(lookup_json_string(http.request.jwt.claims["<TOKEN_CONFIGURATION_ID>"][0], "user") eq "admin" and cf.waf.score < 40)`
* **Action**: *Managed Challenge*

In this example, `<TOKEN_CONFIGURATION_ID>` is your [token configuration ID](https://developers.cloudflare.com/api-shield/security/jwt-validation/api/) found in JWT Validation and `user` is the JWT claim.
